/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.panes;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.ftb.data.LauncherStyle;
import net.ftb.data.Map;
import net.ftb.data.ModPack;
import net.ftb.data.events.MapListener;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.MapFilterDialog;
import net.ftb.gui.dialogs.SearchDialog;
import net.ftb.gui.panes.ILauncherPane;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public class MapUtils
extends JPanel
implements ILauncherPane,
MapListener {
    protected static JPanel maps;
    public static ArrayList<JPanel> mapPanels;
    private static JScrollPane mapsScroll;
    private static JLabel typeLbl;
    private static JButton filter;
    private static int selectedMap;
    protected static boolean mapsAdded;
    public static String type;
    public static String origin;
    public static String compatible;
    private JButton mapButton;
    private JButton textureButton;
    private static JEditorPane mapInfo;
    public static boolean loaded;
    private static MapUtils instance;
    private static HashMap<Integer, Map> currentMaps;

    public MapUtils() {
        instance = this;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(null);
        this.setup();
    }

    @Override
    public void onVisible() {
        MapUtils.sortMaps();
        MapUtils.updateFilter();
        MapUtils.getInstance();
        MapUtils.getMapsScroll().getViewport().setViewPosition(new Point(0, 0));
    }

    public void setup() {
        mapPanels = new ArrayList();
        maps = new JPanel();
        maps.setLayout(null);
        maps.setOpaque(false);
        JPanel p = new JPanel();
        p.setBounds(0, 0, 420, 55);
        p.setLayout(null);
        filter = new JButton(I18N.getLocaleString("FILTER_SETTINGS"));
        filter.setBounds(5, 5, 105, 25);
        filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (loaded) {
                    MapFilterDialog filterDia = new MapFilterDialog(MapUtils.getInstance());
                    filterDia.setVisible(true);
                }
            }
        });
        MapUtils.getInstance().add(filter);
        this.mapButton = new JButton(I18N.getLocaleString("SWAP_MAP"));
        this.mapButton.setBounds(400, 5, 105, 25);
        this.mapButton.setBackground(UIManager.getColor("control").darker().darker());
        this.mapButton.setForeground(UIManager.getColor("text").darker());
        this.mapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.getInstance().swapTabs(true);
            }
        });
        this.add(this.mapButton);
        this.textureButton = new JButton(I18N.getLocaleString("SWAP_TEXTURE"));
        this.textureButton.setBounds(510, 5, 105, 25);
        this.textureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.getInstance().swapTabs(false);
            }
        });
        this.add(this.textureButton);
        String filterTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterTextColor);
        String filterInnerTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterInnerTextColor);
        String typeLblText = "<html><body>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\">Filter: </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + type + "</font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterTextColor + ")\"> / </font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + origin + "</font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterTextColor + ")\"> / </font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + compatible + "</font>";
        typeLblText = typeLblText + "</body></html>";
        typeLbl = new JLabel(typeLblText);
        typeLbl.setBounds(115, 5, 295, 25);
        typeLbl.setHorizontalAlignment(0);
        MapUtils.getInstance().add(typeLbl);
        JTextArea filler = new JTextArea(I18N.getLocaleString("MAPS_WAIT_WHILE_LOADING"));
        filler.setBorder(null);
        filler.setEditable(false);
        filler.setForeground(Color.white);
        filler.setBounds(58, 6, 378, 42);
        filler.setBackground(new Color(255, 255, 255, 0));
        p.add(filler);
        maps.add(p);
        mapsScroll = new JScrollPane();
        mapsScroll.setBounds(-3, 30, 420, 283);
        mapsScroll.setHorizontalScrollBarPolicy(31);
        mapsScroll.setVerticalScrollBarPolicy(22);
        mapsScroll.setWheelScrollingEnabled(true);
        mapsScroll.setOpaque(false);
        mapsScroll.setViewportView(maps);
        mapsScroll.getVerticalScrollBar().setUnitIncrement(19);
        this.add(mapsScroll);
        mapInfo = new JEditorPane();
        mapInfo.setEditable(false);
        mapInfo.setContentType("text/html");
        mapInfo.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OSUtils.browse(event.getURL().toString());
                }
            }
        });
        mapInfo.setBounds(420, 210, 410, 90);
        mapInfo.setBackground(UIManager.getColor("control").darker().darker());
        this.add(mapInfo);
        JScrollPane infoScroll = new JScrollPane();
        infoScroll.setBounds(410, 25, 430, 290);
        infoScroll.setHorizontalScrollBarPolicy(31);
        infoScroll.setVerticalScrollBarPolicy(20);
        infoScroll.setWheelScrollingEnabled(true);
        infoScroll.setViewportView(mapInfo);
        infoScroll.setOpaque(false);
        this.add(infoScroll);
    }

    public static void addMap(Map map) {
        if (!mapsAdded) {
            mapsAdded = true;
            maps.removeAll();
        }
        final int mapIndex = mapPanels.size();
        JPanel p = new JPanel();
        p.setBounds(0, mapIndex * 55, 420, 55);
        p.setLayout(null);
        JLabel logo = new JLabel(new ImageIcon(map.getLogo()));
        logo.setBounds(6, 6, 42, 42);
        logo.setVisible(true);
        JTextArea filler = new JTextArea(map.getName() + " (v." + map.getVersion() + ")\n" + "By " + map.getAuthor());
        filler.setBorder(null);
        filler.setEditable(false);
        filler.setForeground(Color.white);
        filler.setBounds(58, 6, 378, 42);
        filler.setBackground(LauncherStyle.getCurrentStyle().tabPaneBackground);
        MouseAdapter lin = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                selectedMap = mapIndex;
                MapUtils.updateMaps();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                selectedMap = mapIndex;
                MapUtils.updateMaps();
            }
        };
        p.addMouseListener(lin);
        filler.addMouseListener(lin);
        logo.addMouseListener(lin);
        p.add(filler);
        p.add(logo);
        mapPanels.add(p);
        maps.add(p);
        if (origin.equalsIgnoreCase("all")) {
            maps.setMinimumSize(new Dimension(420, Map.getMapArray().size() * 55));
            maps.setPreferredSize(new Dimension(420, Map.getMapArray().size() * 55));
        } else {
            maps.setMinimumSize(new Dimension(420, currentMaps.size() * 55));
            maps.setPreferredSize(new Dimension(420, currentMaps.size() * 55));
        }
        mapsScroll.revalidate();
    }

    @Override
    public void onMapAdded(Map map) {
        final Map map_ = map;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapUtils.addMap(map_);
                Logger.logInfo("Adding map " + MapUtils.getMapNum() + " (" + map_.getName() + ")");
                MapUtils.updateMaps();
            }
        });
    }

    public static void sortMaps() {
        mapPanels.clear();
        maps.removeAll();
        currentMaps.clear();
        int counter = 0;
        selectedMap = 0;
        maps.repaint();
        LaunchFrame.updateMapInstallLocs(new String[]{""});
        mapInfo.setText("");
        HashMap sorted = Maps.newHashMap();
        sorted.put(0, new ArrayList());
        sorted.put(1, new ArrayList());
        for (Map map : Map.getMapArray()) {
            if (!MapUtils.originCheck(map) || !MapUtils.compatibilityCheck(map) || !MapUtils.textSearch(map)) continue;
            if (map.isCompatible(ModPack.getSelectedPack(true).getName())) {
                ((List)sorted.get(1)).add(map);
                continue;
            }
            if (map.isCompatible(ModPack.getSelectedPack(false).getName())) {
                ((List)sorted.get(1)).add(map);
                continue;
            }
            ((List)sorted.get(0)).add(map);
        }
        for (Map map : (List)sorted.get(1)) {
            MapUtils.addMap(map);
            currentMaps.put(counter, map);
            ++counter;
        }
        for (Map map : (List)sorted.get(0)) {
            MapUtils.addMap(map);
            currentMaps.put(counter, map);
            ++counter;
        }
        MapUtils.updateMaps();
    }

    private static void updateMaps() {
        for (int i = 0; i < mapPanels.size(); ++i) {
            if (selectedMap == i) {
                String packs = "";
                if (Map.getMap(MapUtils.getIndex()).getCompatible() != null) {
                    packs = packs + "<p>This map works with the following packs:</p><ul>";
                    for (String name : Map.getMap(MapUtils.getIndex()).getCompatible()) {
                        packs = packs + "<li>" + (ModPack.getPack(name) != null ? ModPack.getPack(name).getName() : name) + "</li>";
                    }
                    packs = packs + "</ul>";
                }
                mapPanels.get(i).setBackground(UIManager.getColor("control").darker().darker());
                mapPanels.get(i).setCursor(Cursor.getPredefinedCursor(0));
                LaunchFrame.updateMapInstallLocs(Map.getMap(MapUtils.getIndex()).getCompatible());
                File tempDir = new File(OSUtils.getCacheStorageLocation(), "Maps" + File.separator + Map.getMap(MapUtils.getIndex()).getMapName());
                mapInfo.setText("<html><img src='file:///" + tempDir.getPath() + File.separator + Map.getMap(MapUtils.getIndex()).getImageName() + "' width=400 height=200></img> <br>" + Map.getMap(MapUtils.getIndex()).getInfo() + packs);
                mapInfo.setCaretPosition(0);
                continue;
            }
            mapPanels.get(i).setBackground(UIManager.getColor("control"));
            mapPanels.get(i).setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public static int getSelectedMapIndex() {
        return mapsAdded ? MapUtils.getIndex() : -1;
    }

    public static void updateFilter() {
        String filterTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterTextColor);
        String filterInnerTextColor = LauncherStyle.getColorAsString(LauncherStyle.getCurrentStyle().filterInnerTextColor);
        String typeLblText = "<html><body>";
        typeLblText = typeLblText + "<strong><font color=rgb\"(" + filterTextColor + ")\">Filter: </strong></font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + type + "</font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterTextColor + ")\"> / </font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + origin + "</font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterTextColor + ")\"> / </font>";
        typeLblText = typeLblText + "<font color=rgb\"(" + filterInnerTextColor + ")\">" + compatible + "</font>";
        typeLblText = typeLblText + "</body></html>";
        typeLbl.setText(typeLblText);
        MapUtils.sortMaps();
        LaunchFrame.getInstance().updateFooter();
    }

    private static int getIndex() {
        return currentMaps.size() > 0 ? currentMaps.get(selectedMap).getIndex() : selectedMap;
    }

    private static int getMapNum() {
        if (currentMaps.size() > 0 && !origin.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL"))) {
            return currentMaps.get(mapPanels.size() - 1).getIndex();
        }
        return mapPanels.size();
    }

    public void updateLocale() {
        filter.setText(I18N.getLocaleString("FILTER_SETTINGS"));
    }

    private static boolean originCheck(Map map) {
        return origin.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) || origin.equalsIgnoreCase("ftb") && map.getAuthor().equalsIgnoreCase("the ftb team") || origin.equalsIgnoreCase(I18N.getLocaleString("FILTER_3THPARTY")) && !map.getAuthor().equalsIgnoreCase("the ftb team");
    }

    private static boolean compatibilityCheck(Map map) {
        return compatible.equalsIgnoreCase(I18N.getLocaleString("MAIN_ALL")) || map.isCompatible(compatible);
    }

    private static boolean textSearch(Map map) {
        String searchString = SearchDialog.lastMapSearch.toLowerCase();
        return searchString.isEmpty() || map.getName().toLowerCase().contains(searchString) || map.getAuthor().toLowerCase().contains(searchString);
    }

    public static JScrollPane getMapsScroll() {
        return mapsScroll;
    }

    public static MapUtils getInstance() {
        return instance;
    }

    static {
        selectedMap = 0;
        mapsAdded = false;
        type = "Client";
        origin = "All";
        compatible = "All";
        loaded = false;
        currentMaps = Maps.newHashMap();
    }
}

